## Where is Zuck?

All this talk of acquisitions and war makes me hungry. Where is the other famously acquisitive big tech CEO? Ben Thompson’s [recent survey of BigTech AI efforts](https://stratechery.com/2023/ai-and-the-big-five/) mostly focused on generative AI for content creators and the Metaverse, but entertainment looks to be far lower value than utility.

Mark Zuckerberg has famously demonstrated complete willingness to make acquisitions of potential future platforms, happily spending large percentages of his market cap to ensure continued relevance. Instagram was bought for $1b in 2012 when Facebook was at a $63b market cap, and then Oculus and Whatsapp for $2b and $19b in 2014 when Facebook was at $220b.

**Where is Zuck in all this?**

Facebook AI Research ([FAIR](https://engineering.fb.com/2018/12/05/ai-research/fair-fifth-anniversary/)), now [Meta AI](https://en.wikipedia.org/wiki/Meta_AI), was started in 2013[7](#footnote-7) led by Turing Award winner [Yann LeCun](https://en.wikipedia.org/wiki/Yann_LeCun) and joined by [Vladimir Vapnik](https://en.wikipedia.org/wiki/Vladimir_Vapnik) of SVM and VC theory fame. They released [PyTorch](https://en.wikipedia.org/wiki/PyTorch) in 2017 which defeated Google’s Tensorflow to become the overwhelmingly preferred Python machine learning framework (including both OpenAI GPT3 and Stable Diffusion). In 2022, Meta AI [open source OPT-175B](https://ai.facebook.com/blog/democratizing-access-to-large-scale-language-models-with-opt-175b/), which follows the [Open Source AI](https://lspace.swyx.io/p/open-source-ai) trend we discussed last year, right down to open sourcing their [daily logbook](https://github.com/facebookresearch/metaseq/blob/main/projects/OPT/chronicles/OPT175B_Logbook.pdf?fbclid=IwAR1Umc_xy5dpckpYqbicRb_uapaDmac7eO8QlnujXKevshidXBx6ytA4YWs).

However… OPT was simply not that good, underperforming models from OpenAI and other smaller startups on the [Stanford CRFM HELM benchmarks](https://crfm.stanford.edu/helm/latest/?group=core_scenarios). The other big launch, Galactica AI, was [taken down in three days](https://futurism.com/the-byte/facebook-takes-down-galactica-ai) after Yann embarrassingly [overstated](https://twitter.com/ylecun/status/1592619400024428544) its ability to generate scientifically accurate papers. John Carmack, the famous Doom creator and consulting CTO at Meta, [left to work on AGI](https://news.ycombinator.com/item?id=34022484), complaining about the inefficiency and institutional inertia he faced despite his personal credibility.

There is just a certain cognitive dissonance in seeing Zuck invest $10b a year into an unproven Metaverse, when OpenAI is making tens of millions and making deals with Microsoft that anticipate returning profit of [up to $150b](https://twitter.com/nonmayorpete/status/1613234091197071360?s=20).

[

![Twitter avatar for @swyx](https://substackcdn.com/image/twitter_name/w_96/swyx.jpg)

swyx 🇸🇬 @swyx

![meme about metaverse vs AI](https://substackcdn.com/image/fetch/w_600,c_limit,f_auto,q_auto:good,fl_progressive:steep/https%3A%2F%2Fpbs.substack.com%2Fmedia%2FFmRpPiDagAIt7OX.png)



](https://twitter.com/swyx/status/1613530352865411073)[

8:36 AM ∙ Jan 12, 2023

---

230Likes29Retweets



](https://twitter.com/swyx/status/1613530352865411073)